#ifndef CAP_H
#define CAP_H

#ifdef CAP_VB_EXPORT

#define ADO_CAPTURE_EXPORT __stdcall

#else 

#define ADO_CAPTURE_EXPORT __cdecl

#endif 

#ifdef ADO_CAPTURE_EXPORT

#define CAP_API __declspec(dllexport)

#else

#define CAP_API __declspec(dllimport)

#endif

#ifdef __cplusplus

#define EXTERN_C extern "C"

#endif

// ##############################################################################################################################################################################
// #
// # ERROR CODE DEFINITION
// # 
// ##############################################################################################################################################################################

// RESULT OF FUNCTION
//
typedef enum {

	ADO_RS_SUCCESSFUL				= 0x00000000,

	ADO_RS_ERROR_GENERAL			= 0x00000001,		

} ADO_RESULT;

// EVENTS FROM ADOBE CS PREMIRE APPLICATION
//
typedef enum {	

	ADOBE_PLUGIN_STARTUP_EVENT			= 0,

	ADOBE_PLUGIN_SHUTDOWN_EVENT			= 1,

	ADOBE_PLUGIN_DISPLAY_WND_EVENT		= 2,

	ADOBE_PLUGIN_START_PREVIEW_EVENT	= 3,

	ADOBE_PLUGIN_STOP_PREVIEW_EVENT		= 4,

	ADOBE_PLUGIN_START_RECORD_EVENT		= 5,

	ADOBE_PLUGIN_PAUSE_RECORD_EVENT		= 6,

	ADOBE_PLUGIN_STOP_RECORD_EVENT		= 7,

	ADOBE_PLUGIN_SHOW_SETUP_UI_EVENT	= 8

} ADOBE_PLUGIN_CAPTURE_EVENT;

//
// EXPORT FUNCTION
//
EXTERN_C CAP_API ADO_RESULT ADO_CAPTURE_EXPORT RecevieAdobeCaptureEvents( ULONG nEvent /*IN*/, PVOID pAttachedData /*IN*/ );

#endif